---
title: SadTalker API Usage Guide
slug: v-jLmWFv0B5P3yrLwoFoA
createdAt: Thu Jul 18 2024 06:07:52 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:42:11 GMT+0000 (Coordinated Universal Time)
---

# SadTalker API Usage Guide

## Introduction

This document will guide developers on how to use the aonet library to call the SadTalker API, which is used to generate AI-driven talking avatars.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Installation

Ensure that the aonet library is installed. If it is not installed yet, you can install it using npm:

```bash
npm install aonet
```

## Steps to Use

### 1. Import the aonet library

```js
const AI = require("aonet");
```

### 2. Configure Options

Create an options object that includes your APPID:

```js
const options = {
    appid: "your APPID"
};
```

Make sure to replace "your APPID" with your actual Aonet APPID.

### 3. Initialize AI Instance

Initialize the AI instance using the configuration options:

```js
const aonet = new AI(options);
```

### 4. Call the SadTalker API

Use the `prediction` method to call the SadTalker API:

```js
async function generateTalkingAvatar() {
    try {
        let response = await aonet.prediction("/predictions/ai/sadtalker",
        {
            input: {
                "still": true,
                "enhancer": "gfpgan",
                "preprocess": "full",
                "driven_audio": "https://aonet.ai/pbxt/Jf1gczNATWiC94VPrsTTLuXI0ZmtuZ6k0aWBcQpr7VuRc5f3/japanese.wav",
                "source_image": "https://replicate.delivery/pbxt/Jf1gcsODejVsGRd42eeUj0RXX11zjxzHuLuqXmVFwMAi2tZq/art_1.png"
            }
        });
        console.log("SadTalker result:", response);
    } catch (error) {
        console.error("Error generating talking avatar:", error);
    }
}

generateTalkingAvatar();
```

### Parameter Description

- `still`: Boolean, set to true to generate a static image instead of a video.
- `enhancer`: String, specifies the image enhancer to use, here using "gfpgan".
- `preprocess`: String, specifies the preprocessing method, here using "full".
- `driven_audio`: String, the URL of the audio file to drive the animation.
- `source_image`: String, the URL of the source image, which is the avatar to be animated.

### Notes

- Ensure that the provided image and audio URLs are publicly accessible.
- The API may take some time to process the input and generate the result, consider implementing appropriate wait or retry logic.
- Handle possible errors, such as network issues, invalid input, or API limitations.

### Example Response

The API response will contain the URL of the generated talking avatar or other relevant information. Parse and use the response data according to the actual API documentation.

## Advanced Usage

- Implement error retry mechanisms, especially for long-running tasks.
- Add input validation logic to ensure the provided URLs point to valid image and audio files.
- Consider implementing progress tracking, especially for generating video output.
- For production environments, implement rate limiting and caching mechanisms to optimize API usage.

